 ; Ŀ
 ;   45, 90, and 180 - entity rotators.                                    
 ;   Copyright 1994, 2008, 2010 by Rocket Software Ltd.                    
 ; 

 ; Ŀ
 ;   Subroutine 9o - rotate a selected entity.                             
 ;   Note: you can defun c:90, but not defun 90.                           
 ; 
 (DEFUN 9O (anga / *error* snapp enam entt ten tenp)
  (setvar "cmdecho" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Locally redefine the error handler.                                   
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get an entity.                                                        
 ; 
  (setq entt (entget (setq enam (car (entsel "Entity to rotate: ")))))
  (setvar "snapmode" snapp)
  (setq typ (cdr (assoc 0 entt)))
  (cond ((= typ "POLYLINE")
         (setq entt (entget (entnext enam)))
         (setq ten (cdr (assoc 10 entt))))
        ((member typ '("TEXT" "ATTDEF"))
         (setq ten (spit entt)))
        (t
         (setq ten (cdr (assoc 10 entt)))))
  (setq tenp (getpoint ten "\nRotation base or <Return> to use entity base: "))
  (if tenp (setq ten tenp))
  (command "rotate" enam "" ten anga)
 (princ))
 ; Ŀ
 ;   Subroutine 9o end.                                                    
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 
                     
 ; Ŀ
 ;   90 - rotate an entity 90 around its insertion.                       
 ;   Why does nobody ever get tattoos on the soles of their feet?          
 ; 
 (DEFUN C:90 ()
  (9o 90)
 (princ))

 ; Ŀ
 ;   180 - rotate an entity 180 around its insertion.                     
 ;   Originally Etator - Portugese for sandwich.                           
 ; 
 (DEFUN C:180 ()
  (9o 180)
 (princ))

 ; Ŀ
 ;   45 - rotate an entity 45 around its insertion.                       
 ;   Originally Etato - Quebecois for ripple chip.                         
 ; 
 (DEFUN C:45 ()
  (9o 45)
 (princ))

(princ)